string GetDescription()
{
	return "This is a simple random harmony script.\n - Uses only chords from the triad\n - Either one chord per bar or two";
}

void GenerateHarmony(UniquePart @up)
{
	int mode = RndInt(1,2);
	int sec_placement = RndInt(1,up.GetMetrum()-1);
	
	if (up.GetMetrum() == 2) sec_placement = 1;
	if (up.GetMetrum() == 4) sec_placement = 2;
	if (up.GetMetrum() == 3) sec_placement = 2;
	if (up.GetMetrum() == 5) sec_placement = RndInt(2,3);
	if (up.GetMetrum() == 6) sec_placement = 3;
	if (up.GetMetrum() == 7) sec_placement = RndInt(3,4);
	if (up.GetMetrum() == 8) sec_placement = 4;
	
	if (mode == 1)
	{
		up.AddHarmonic(CreateTime(0,0), 1, "135");
		
		for (int i = 1; i < up.GetBars()-2; i++)
		{
			int tmp = RndInt(0,2);
			int basis = 1;
			if (tmp == 1) basis = 4;
			if (tmp == 2) basis = 5;
			up.AddHarmonic(CreateTime(i,0), basis, "135");
		}
		
		up.AddHarmonic(CreateTime(up.GetBars()-2,0), 5, "135");
		up.AddHarmonic(CreateTime(up.GetBars()-1,0), 1, "135");
	}
	else
	{
		up.AddHarmonic(CreateTime(0,0), 1, "135");
		
		for (int i = 0; i < up.GetBars()-1; i++)
		{
			if (i != 0)
			{
				int tmp = RndInt(0,2);
				int basis = 1;
				if (tmp == 1) basis = 4;
				if (tmp == 2) basis = 5;
				up.AddHarmonic(CreateTime(i,0), basis, "135");
			}
			if (i != up.GetBars()-2)
			{
				int tmp = RndInt(0,2);
				int basis = 1;
				if (tmp == 1) basis = 4;
				if (tmp == 2) basis = 5;
				up.AddHarmonic(CreateTime(i,sec_placement), basis, "135");
			}
		}
		
		up.AddHarmonic(CreateTime(up.GetBars()-2,sec_placement), 5, "135");
		up.AddHarmonic(CreateTime(up.GetBars()-1,0), 1, "135");
	}
}